
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name='milligrams_of_vitamin_E', lb=-GRB.INFINITY, ub=GRB.INFINITY)
x2 = m.addVar(name='milligrams_of_zinc', lb=-GRB.INFINITY, ub=GRB.INFINITY)

# Set the objective function
m.setObjective(1.63*x1 + 8.5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.6*x1 + 1.85*x2 >= 21, name='total_muscle_growth_index_lower_bound')
m.addConstr(1.24*x1 + 1.83*x2 >= 21, name='total_immune_support_index_lower_bound')
m.addConstr(7*x1 - 5*x2 >= 0, name='additional_constraint')
m.addConstr(0.6*x1 + 1.85*x2 <= 33, name='total_muscle_growth_index_upper_bound')
m.addConstr(1.24*x1 + 1.83*x2 <= 26, name='total_immune_support_index_upper_bound')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of Vitamin E:", x1.x)
    print("Milligrams of Zinc:", x2.x)
else:
    print("No optimal solution found.")
