
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="milligrams_of_vitamin_E")
    x2 = model.addVar(lb=0, name="milligrams_of_zinc")

    # Define the objective function
    model.setObjective(1.63 * x1 + 8.5 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.6 * x1 + 1.85 * x2 >= 21, name="muscle_growth_index_min")
    model.addConstr(0.6 * x1 + 1.85 * x2 <= 33, name="muscle_growth_index_max")
    model.addConstr(1.24 * x1 + 1.83 * x2 >= 21, name="immune_support_index_min")
    model.addConstr(1.24 * x1 + 1.83 * x2 <= 26, name="immune_support_index_max")
    model.addConstr(7 * x1 - 5 * x2 >= 0, name="vitamin_zinc_balance")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x1.varValue}")
        print(f"Milligrams of zinc: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
