
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
x = model.addVars(5, vtype=gp.GRB.INTEGER, name=["blue pens", "3D printers", "headsets", "wooden pencils", "planners"])

# Set objective function
model.setObjective(5.4 * x[0] + 3.95 * x[1] + 8.46 * x[2] + 2.29 * x[3] + 2.54 * x[4], gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * x[0] + 3 * x[1] + 5 * x[2] + 3 * x[3] + 4 * x[4] <= 51, "dollar cost")
model.addConstr(4 * x[0] + 3 * x[1] + 3 * x[2] + 5 * x[3] + 1 * x[4] <= 44, "storage space")
model.addConstr(5 * x[2] + 4 * x[4] >= 6, "headsets_planners_cost")
model.addConstr(5 * x[0] + 3 * x[1] >= 5, "blue_pens_3D_printers_cost")


model.addConstr(5 * x[0] + 3 * x[3] + 4 * x[4] >= 10, "c1")
model.addConstr(5 * x[2] + 3 * x[3] + 4 * x[4] >= 10, "c2")
model.addConstr(5 * x[0] + 3 * x[1] + 4 * x[4] >= 10, "c3")
model.addConstr(5 * x[0] + 3 * x[1] + 5 * x[2] >= 10, "c4")
model.addConstr(5 * x[0] + 5 * x[2] + 4 * x[4] >= 10, "c5")
model.addConstr(3 * x[1] + 3 * x[3] + 4 * x[4] >= 10, "c6")

model.addConstr(5 * x[0] + 3 * x[3] + 4 * x[4] >= 5, "c7")
model.addConstr(5 * x[2] + 3 * x[3] + 4 * x[4] >= 5, "c8")
model.addConstr(5 * x[0] + 3 * x[1] + 4 * x[4] >= 5, "c9")
model.addConstr(5 * x[0] + 3 * x[1] + 5 * x[2] >= 5, "c10")
model.addConstr(5 * x[0] + 5 * x[2] + 4 * x[4] >= 5, "c11")
model.addConstr(3 * x[1] + 3 * x[3] + 4 * x[4] >= 5, "c12")
model.addConstr(5 * x[0] + 3 * x[1] + 5 * x[2] + 3 * x[3] + 4 * x[4] >= 5, "c13")


model.addConstr(3 * x[1] + 1 * x[4] >= 7, "s1")
model.addConstr(4 * x[0] + 3 * x[1] >= 7, "s2")
model.addConstr(3 * x[1] + 5 * x[3] >= 5, "s3")
model.addConstr(3 * x[2] + 5 * x[3] + 1 * x[4] >= 6, "s4")
model.addConstr(3 * x[1] + 3 * x[2] + 1 * x[4] >= 6, "s5")
model.addConstr(3 * x[2] + 5 * x[3] + 1 * x[4] >= 5, "s6")
model.addConstr(3 * x[1] + 3 * x[2] + 1 * x[4] >= 5, "s7")
model.addConstr(4 * x[0] + 3 * x[1] + 3 * x[2] + 5 * x[3] + 1 * x[4] >= 5, "s8")

model.addConstr(5 * x[0] + 4 * x[4] <= 15, "u1")
model.addConstr(3 * x[1] + 4 * x[4] <= 51, "u2")
model.addConstr(5 * x[0] + 3 * x[3] <= 50, "u3")
model.addConstr(5 * x[0] + 3 * x[1] <= 14, "u4")
model.addConstr(5 * x[2] + 3 * x[3] <= 28, "u5")
model.addConstr(5 * x[0] + 5 * x[2] <= 27, "u6")
model.addConstr(5 * x[2] + 4 * x[4] <= 30, "u7")
model.addConstr(5 * x[0] + 3 * x[3] + 4 * x[4] <= 27, "u8")
model.addConstr(3 * x[1] + 5 * x[2] + 3 * x[3] <= 41, "u9")
model.addConstr(5 * x[2] + 3 * x[3] + 4 * x[4] <= 19, "u10")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

