
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry pies")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")


    # Set objective function
    m.setObjective(1*x0 + 5*x1 + 9*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 13*x1 + 4*x2 <= 196, "sourness_index_limit")
    m.addConstr(15*x0 + 20*x1 + 19*x2 <= 332, "healthiness_rating_limit")
    m.addConstr(13*x1 + 4*x2 >= 63, "banana_cornichon_sourness")
    m.addConstr(7*x0 + 4*x2 >= 39, "blueberry_cornichon_sourness")
    m.addConstr(7*x0 + 13*x1 >= 61, "blueberry_banana_sourness")
    m.addConstr(7*x0 + 13*x1 + 4*x2 >= 61, "total_sourness")
    m.addConstr(15*x0 + 20*x1 >= 69, "blueberry_banana_healthiness")
    m.addConstr(20*x1 + 19*x2 >= 93, "banana_cornichon_healthiness")
    m.addConstr(15*x0 + 20*x1 + 19*x2 >= 93, "total_healthiness")
    m.addConstr(-9*x1 + 2*x2 >= 0, "banana_cornichon_relation")
    m.addConstr(7*x0 + 13*x1 <= 88, "blueberry_banana_sourness_upper")
    m.addConstr(13*x1 + 4*x2 <= 167, "banana_cornichon_sourness_upper")
    m.addConstr(15*x0 + 19*x2 <= 143, "blueberry_cornichon_healthiness_upper")
    m.addConstr(15*x0 + 20*x1 <= 229, "blueberry_banana_healthiness_upper")
    m.addConstr(20*x1 + 19*x2 <= 289, "banana_cornichon_healthiness_upper")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
