
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="blueberry_pies", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="bananas", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="cornichons", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(1 * x0 + 5 * x1 + 9 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(13 * x1 + 4 * x2 >= 63)
    model.addConstr(7 * x0 + 4 * x2 >= 39)
    model.addConstr(7 * x0 + 13 * x1 >= 61)
    model.addConstr(7 * x0 + 13 * x1 + 4 * x2 >= 61)
    model.addConstr(15 * x0 + 20 * x1 >= 69)
    model.addConstr(20 * x1 + 19 * x2 >= 93)
    model.addConstr(15 * x0 + 20 * x1 + 19 * x2 >= 93)
    model.addConstr(-9 * x1 + 2 * x2 >= 0)
    model.addConstr(7 * x0 + 13 * x1 <= 88)
    model.addConstr(13 * x1 + 4 * x2 <= 167)
    model.addConstr(15 * x0 + 19 * x2 <= 143)
    model.addConstr(15 * x0 + 20 * x1 <= 229)
    model.addConstr(20 * x1 + 19 * x2 <= 289)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Blueberry pies: {x0.varValue}")
        print(f"Bananas: {x1.varValue}")
        print(f"Cornichons: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
