
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Work_Optimization")

    # Create variables
    paul_hours = model.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")
    hank_hours = model.addVar(vtype=gp.GRB.INTEGER, name="hank_hours")
    mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")


    # Set objective function
    model.setObjective(6.35 * paul_hours + 3.95 * hank_hours + 9.82 * mary_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.95 * paul_hours + 0.55 * hank_hours >= 24, "c1")
    model.addConstr(0.95 * paul_hours + 0.55 * hank_hours + 0.72 * mary_hours >= 16, "c2")
    model.addConstr(0.95 * paul_hours + 0.72 * mary_hours <= 61, "c3")
    model.addConstr(0.95 * paul_hours + 0.55 * hank_hours + 0.72 * mary_hours <= 61, "c4")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Paul's hours: {paul_hours.x}")
        print(f"Hank's hours: {hank_hours.x}")
        print(f"Mary's hours: {mary_hours.x}")
        print(f"Optimal Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
