
from gurobipy import *

# Create a new model
m = Model("Work_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
x3 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")

# Define the objective function
m.setObjective(6.35*x1 + 3.95*x2 + 9.82*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.95*x1 + 0.55*x2 >= 24, "Min_Quality_Paul_Hank")
m.addConstr(0.95*x1 + 0.55*x2 + 0.72*x3 >= 16, "Min_Quality_All")
m.addConstr(0.95*x1 + 0.72*x3 <= 61, "Max_Quality_Paul_Mary")
m.addConstr(0.95*x1 + 0.55*x2 + 0.72*x3 <= 61, "Max_Quality_All")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Hank: {x2.x}")
    print(f"Hours worked by Mary: {x3.x}")
else:
    print("No optimal solution found")
