
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Paul
    x2 = model.addVar(name='x2', lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Hank
    x3 = model.addVar(name='x3', lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Mary

    # Define the objective function
    model.setObjective(6.35*x1 + 3.95*x2 + 9.82*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.95*x1 + 0.55*x2 >= 24)
    model.addConstr(0.95*x1 + 0.55*x2 + 0.72*x3 >= 16)
    model.addConstr(0.95*x1 + 0.72*x3 <= 61)
    model.addConstr(0.95*x1 + 0.55*x2 + 0.72*x3 <= 61)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Paul: ', x1.varValue)
        print('Hours worked by Hank: ', x2.varValue)
        print('Hours worked by Mary: ', x3.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
