
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cornichons = m.addVar(lb=0, name="cornichons")
pickles = m.addVar(lb=0, name="pickles")
ramen = m.addVar(lb=0, name="bowls_of_instant_ramen")
bacon = m.addVar(lb=0, name="strips_of_bacon")


# Set objective function
m.setObjective(4*cornichons**2 + 3*cornichons*pickles + 9*pickles**2 + 4*pickles*bacon + 4*ramen**2 + 9*pickles + 4*ramen + 2*bacon, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(30*cornichons**2 + 15*bacon**2 >= 30)
m.addConstr(8*pickles**2 + 15*bacon**2 >= 32)
m.addConstr(30*cornichons + 32*ramen + 15*bacon >= 26)
m.addConstr(8*pickles**2 + 32*ramen**2 + 15*bacon**2 >= 26)
m.addConstr(30*cornichons**2 + 8*pickles**2 + 15*bacon**2 >= 26)
m.addConstr(30*cornichons**2 + 32*ramen**2 + 15*bacon**2 >= 40)
m.addConstr(8*pickles + 32*ramen + 15*bacon >= 40)
m.addConstr(30*cornichons + 8*pickles + 15*bacon >= 40)
m.addConstr(30*cornichons + 32*ramen + 15*bacon >= 33)
m.addConstr(8*pickles + 32*ramen + 15*bacon >= 33)
m.addConstr(30*cornichons**2 + 8*pickles**2 + 15*bacon**2 >= 33)
m.addConstr(30*cornichons + 8*pickles + 32*ramen + 15*bacon >= 33)
m.addConstr(22*pickles + 30*bacon >= 30)
m.addConstr(21*ramen + 30*bacon >= 34)
m.addConstr(28*cornichons + 30*bacon >= 45)
m.addConstr(28*cornichons**2 + 22*pickles**2 >= 34)
m.addConstr(22*pickles**2 + 21*ramen**2 >= 32)
m.addConstr(28*cornichons + 21*ramen + 30*bacon >= 48)
m.addConstr(28*cornichons + 22*pickles + 21*ramen + 30*bacon >= 48)
m.addConstr(31*ramen + 20*bacon >= 29)
m.addConstr(23*cornichons + 20*bacon >= 18)
m.addConstr(3*pickles + 20*bacon >= 43)
m.addConstr(3*pickles + 31*ramen >= 42)
m.addConstr(23*cornichons + 31*ramen >= 43)
m.addConstr(23*cornichons + 3*pickles >= 37)
m.addConstr(23*cornichons + 3*pickles + 31*ramen >= 31)
m.addConstr(23*cornichons + 3*pickles + 31*ramen + 20*bacon >= 31)
m.addConstr(-4*cornichons**2 + 4*pickles**2 >= 0)
m.addConstr(-2*pickles + 4*bacon >= 0)
m.addConstr(30*cornichons + 8*pickles + 32*ramen <= 149)
m.addConstr(8*pickles + 32*ramen + 15*bacon <= 170)
m.addConstr(28*cornichons + 22*pickles <= 131)
m.addConstr(21*ramen + 30*bacon <= 159)
m.addConstr(28*cornichons + 30*bacon <= 55)
m.addConstr(22*pickles + 21*ramen <= 187)
m.addConstr(22*pickles + 30*bacon <= 168)
m.addConstr(28*cornichons**2 + 21*ramen**2 <= 80)
m.addConstr(23*cornichons + 20*bacon <= 70)
m.addConstr(3*pickles + 31*ramen <= 60)
m.addConstr(23*cornichons + 31*ramen <= 97)
m.addConstr(23*cornichons + 3*pickles + 20*bacon <= 154)
m.addConstr(23*cornichons**2 + 31*ramen**2 + 20*bacon**2 <= 85)
m.addConstr(23*cornichons**2 + 3*pickles**2 + 31*ramen**2 <= 93)
m.addConstr(3*pickles**2 + 31*ramen**2 + 20*bacon**2 <= 121)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

