
import gurobi as grb

# Define variables
m = grb.Model()
x0 = m.addVar(lb=-grb.GRB.INFINITY, name="cornichons")
x1 = m.addVar(lb=-grb.GRB.INFINITY, name="pickles")
x2 = m.addVar(lb=-grb.GRB.INFINITY, name="bowls_of_instant_ramen")
x3 = m.addVar(lb=-grb.GRB.INFINITY, name="strips_of_bacon")

# Objective function
m.setObjective(4*x0**2 + 3*x0*x1 + 9*x1**2 + 4*x1*x3 + 4*x2**2 + 9*x1 + 4*x2 + 2*x3, grb.GRB.MINIMIZE)

# Constraints
m.addConstr(30*x0**2 + x3**2 >= 30)
m.addConstr(x1**2 + x3**2 >= 32)
m.addConstr(30*x0 + 32*x2 + 15*x3 >= 26)
m.addConstr(x1**2 + x2**2 + x3**2 >= 26)
m.addConstr(x0**2 + x2**2 + x3**2 >= 40)
m.addConstr(x1 + x2 + x3 >= 40)
m.addConstr(x0 + x1 + x3 >= 40)
m.addConstr(x0 + x2 + x3 >= 33)
m.addConstr(x1 + x2 + x3 >= 33)
m.addConstr(x0**2 + x1**2 + x3**2 >= 33)
m.addConstr(x0 + x1 + x2 + x3 >= 33)
m.addConstr(22*x1 + 30*x3 >= 30)
m.addConstr(21*x2 + 30*x3 >= 34)
m.addConstr(28*x0 + 30*x3 >= 45)
m.addConstr(28**2*x0**2 + 22**2*x1**2 >= 34)
m.addConstr(22**2*x1**2 + 21**2*x2**2 >= 32)
m.addConstr(28*x0 + 21*x2 + 30*x3 >= 48)
m.addConstr(28*x0 + 22*x1 + 21*x2 + 30*x3 >= 48)
m.addConstr(31*x2 + 20*x3 >= 29)
m.addConstr(23*x0 + 20*x3 >= 18)
m.addConstr(3*x1 + 20*x3 >= 43)
m.addConstr(3*x1 + 31*x2 >= 42)
m.addConstr(23*x0 + 31*x2 >= 43)
m.addConstr(23*x0 + 3*x1 >= 37)
m.addConstr(23*x0 + 3*x1 + 31*x2 >= 31)
m.addConstr(23*x0 + 3*x1 + 31*x2 + 20*x3 >= 31)
m.addConstr(-4*x0**2 + 4*x1**2 >= 0)
m.addConstr(-2*x1 + 4*x3 >= 0)
m.addConstr(30*x0 + 8*x1 + 32*x2 <= 149)
m.addConstr(8*x1 + 32*x2 + 15*x3 <= 170)
m.addConstr(28*x0 + 22*x1 <= 131)
m.addConstr(21*x2 + 30*x3 <= 159)
m.addConstr(28*x0 + 30*x3 <= 55)
m.addConstr(22*x1 + 21*x2 <= 187)
m.addConstr(22*x1 + 30*x3 <= 168)
m.addConstr(28**2*x0**2 + 21**2*x2**2 <= 80)
m.addConstr(23*x0 + 20*x3 <= 70)
m.addConstr(3*x1 + 31*x2 <= 60)
m.addConstr(23*x0 + 31*x2 <= 97)
m.addConstr(23*x0 + 3*x1 + 20*x3 <= 154)
m.addConstr(23**2*x0**2 + 31**2*x2**2 + 20**2*x3**2 <= 85)
m.addConstr(23**2*x0**2 + 3**2*x1**2 + 31**2*x2**2 <= 93)
m.addConstr(3**2*x1**2 + 31**2*x2**2 + 20**2*x3**2 <= 121)

# Solve the model
m.optimize()

# Print solution
if m.status == grb.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("No solution found")
