
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="protein_bars", lb=0)  # No upper bound for protein bars, steaks, ravioli, knishes as they can be fractional
x2 = m.addVar(name="steaks", lb=0)
x3 = m.addVar(name="ravioli", lb=0)
x4 = m.addVar(name="knishes", lb=0)

# Define the objective function
m.setObjective(3.09*x1 + 9.24*x2 + 3.08*x3 + 1.7*x4, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(8*x1 + 4*x2 + 3*x3 + 2*x4 >= 14, name="total_protein")
m.addConstr(8*x1 + 3*x3 >= 14, name="protein_bars_ravioli")
m.addConstr(3*x3 + 2*x4 >= 28, name="ravioli_knishes")
m.addConstr(9*x1 - 5*x4 >= 0, name="protein_bars_knishes")
m.addConstr(-10*x3 + 10*x4 >= 0, name="ravioli_knishes_relationship")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Protein bars: {x1.varValue}")
    print(f"Steaks: {x2.varValue}")
    print(f"Ravioli: {x3.varValue}")
    print(f"Knishes: {x4.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
