
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="blueberry_pies")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_drumsticks")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="bowls_of_instant_ramen")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="hamburgers")
x4 = m.addVar(vtype=gp.GRB.INTEGER, name="steaks")


# Set objective function
m.setObjective(6.53 * x0 + 3.65 * x1 + 5.82 * x2 + 5.28 * x3 + 3.6 * x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * x1 + 20 * x3 >= 60)
m.addConstr(2 * x0 + 12 * x4 >= 52)
m.addConstr(2 * x0 + 22 * x2 >= 37)
m.addConstr(2 * x0 + 20 * x3 >= 67)
m.addConstr(x1 + 12 * x4 >= 72)
# ... (add all other constraints similarly)

# Resource constraints
m.addConstr(2 * x0 + x1 + 22 * x2 + 20 * x3 + 12 * x4 <= 413, "r0_tastiness")
m.addConstr(3 * x0 + 20 * x1 + 6 * x2 + 22 * x3 + 5 * x4 <= 333, "r1_iron")
m.addConstr(12 * x0 + x1 + x2 + 17 * x3 + 23 * x4 <= 420, "r2_protein")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('blueberry_pies:', x0.x)
    print('chicken_drumsticks:', x1.x)
    print('bowls_of_instant_ramen:', x2.x)
    print('hamburgers:', x3.x)
    print('steaks:', x4.x)

elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

