
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(4, vtype=gp.GRB.INTEGER, name=["3D_printers", "paper_clips", "office_chairs", "lanyards"])

# Set objective function
m.setObjective(2.05 * x[0] + 6.16 * x[1] + 8.22 * x[2] + 8.27 * x[3], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * x[0] + 15 * x[1] + 12 * x[2] + 2 * x[3] <= 192, "storage_space")
m.addConstr(1 * x[0] + 1 * x[1] + 12 * x[2] + 17 * x[3] <= 129, "workplace_safety")
m.addConstr(16 * x[0] + 12 * x[2] >= 47, "storage_printers_chairs")
m.addConstr(15 * x[1] + 12 * x[2] >= 19, "storage_clips_chairs")
m.addConstr(16 * x[0] + 15 * x[1] + 2 * x[3] >= 39, "storage_printers_clips_lanyards")
m.addConstr(16 * x[0] + 15 * x[1] + 12 * x[2] + 2 * x[3] >= 39, "storage_all")
m.addConstr(1 * x[0] + 12 * x[2] >= 30, "safety_printers_chairs")
m.addConstr(1 * x[0] + 17 * x[3] >= 29, "safety_printers_lanyards")
m.addConstr(1 * x[1] + 17 * x[3] >= 16, "safety_clips_lanyards")
m.addConstr(1 * x[0] + 1 * x[1] + 12 * x[2] + 17 * x[3] >= 16, "safety_all")
m.addConstr(9 * x[0] - 2 * x[1] >= 0, "printers_clips_relation1")
m.addConstr(2 * x[0] - 1 * x[2] >= 0, "printers_chairs_relation")
m.addConstr(16 * x[0] + 12 * x[2] <= 182, "storage_printers_chairs_max")
m.addConstr(16 * x[0] + 15 * x[1] <= 126, "storage_printers_clips_max")
m.addConstr(12 * x[2] + 2 * x[3] <= 137, "storage_chairs_lanyards_max")
m.addConstr(15 * x[1] + 2 * x[3] <= 118, "storage_clips_lanyards_max")
m.addConstr(15 * x[1] + 12 * x[2] <= 190, "storage_clips_chairs_max")
m.addConstr(16 * x[0] + 15 * x[1] + 2 * x[3] <= 140, "storage_printers_clips_lanyards_max")
m.addConstr(1 * x[0] + 17 * x[3] <= 42, "safety_printers_lanyards_max")
m.addConstr(1 * x[1] + 17 * x[3] <= 114, "safety_clips_lanyards_max")
m.addConstr(1 * x[0] + 1 * x[1] <= 112, "safety_printers_clips_max")
m.addConstr(1 * x[1] + 12 * x[2] + 17 * x[3] <= 104, "safety_clips_chairs_lanyards_max")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
