
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="3D_printers", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="paper_clips", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="office_chairs", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="lanyards", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(2.05*x0 + 6.16*x1 + 8.22*x2 + 8.27*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x0 + 15*x1 + 12*x2 + 2*x3 <= 192)
m.addConstr(x0 + x1 + 12*x2 + 17*x3 <= 129)
m.addConstr(16*x0 + 12*x2 >= 47)
m.addConstr(15*x1 + 12*x2 >= 19)
m.addConstr(16*x0 + 15*x1 + 2*x3 >= 39)
m.addConstr(16*x0 + 15*x1 + 12*x2 + 2*x3 >= 39)
m.addConstr(x0 + 12*x2 >= 30)
m.addConstr(x0 + 17*x3 >= 29)
m.addConstr(x1 + 17*x3 >= 16)
m.addConstr(x0 + x1 + 12*x2 + 17*x3 >= 16)
m.addConstr(9*x0 - 2*x1 >= 0)
m.addConstr(2*x0 - x2 >= 0)
m.addConstr(16*x0 + 12*x2 <= 182)
m.addConstr(16*x0 + 15*x1 <= 126)
m.addConstr(12*x2 + 2*x3 <= 137)
m.addConstr(15*x1 + 2*x3 <= 118)
m.addConstr(15*x1 + 12*x2 <= 190)
m.addConstr(16*x0 + 15*x1 + 2*x3 <= 140)
m.addConstr(x0 + 17*x3 <= 42)
m.addConstr(x1 + 17*x3 <= 114)
m.addConstr(x0 + x1 <= 112)
m.addConstr(x1 + 12*x2 + 17*x3 <= 104)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("3D printers: ", x0.varValue)
    print("paper clips: ", x1.varValue)
    print("office chairs: ", x2.varValue)
    print("lanyards: ", x3.varValue)
else:
    print("The model is infeasible")
