
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")


# Set objective function
m.setObjective(6*x0**2 + 5*x0*x1 + 9*x0*x2 + 3*x0*x3 + 6*x0*x4 + 9*x1**2 + 8*x1*x2 + 5*x1*x3 + 2*x1*x4 + 2*x2**2 + 6*x2*x3 + 6*x3**2 + 8*x3*x4 + 3*x4**2 + 7*x0 + 4*x1 + 1*x2 + 3*x3 + 1*x4, gp.GRB.MAXIMIZE)

# Add constraints
constraints_data = {
    'r0': {'upper_bound': 217, 'x0': 8, 'x1': 12, 'x2': 3, 'x3': 5, 'x4': 5},
    'r1': {'upper_bound': 275, 'x0': 15, 'x1': 6, 'x2': 12, 'x3': 7, 'x4': 15},
    'r2': {'upper_bound': 215, 'x0': 20, 'x1': 1, 'x2': 8, 'x3': 8, 'x4': 18},
    'r3': {'upper_bound': 372, 'x0': 11, 'x1': 1, 'x2': 11, 'x3': 19, 'x4': 19}
}

for r, data in constraints_data.items():
    m.addConstr(data['x0'] * x0 + data['x1'] * x1 + data['x2'] * x2 + data['x3'] * x3 + data['x4'] * x4 <= data['upper_bound'], name=r)


with open('constraints.txt', 'r') as f:
    for line in f:
        m.addConstr(eval(line.strip()))


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

