
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("Minimize Work Hours")

    # Create variables
    mary_hours = model.addVar(vtype=GRB.INTEGER, name="x0")  # Mary's hours (integer)
    ringo_hours = model.addVar(vtype=GRB.CONTINUOUS, name="x1") # Ringo's hours (continuous)


    # Set objective function
    model.setObjective(6*mary_hours + 2*ringo_hours, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*mary_hours + 19*ringo_hours >= 24, "org_score_min")
    model.addConstr(13*mary_hours + 12*ringo_hours >= 25, "prod_rating_min")
    model.addConstr(9*mary_hours - 2*ringo_hours >= 0, "mary_ringo_relation")
    model.addConstr(12*mary_hours + 19*ringo_hours <= 62, "org_score_max")
    model.addConstr(13*mary_hours + 12*ringo_hours <= 121, "prod_rating_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print(f"Mary's hours: {mary_hours.x}")
        print(f"Ringo's hours: {ringo_hours.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
