
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")

# Set the objective function
m.setObjective(6*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(12*x1 + 19*x2 >= 24, "Organization_Score_Min")
m.addConstr(13*x1 + 12*x2 >= 25, "Productivity_Rating_Min")
m.addConstr(9*x1 - 2*x2 >= 0, "Hours_Worked_Constraint")
m.addConstr(12*x1 + 19*x2 <= 62, "Organization_Score_Max")
m.addConstr(13*x1 + 12*x2 <= 121, "Productivity_Rating_Max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Mary: {x1.x}")
    print(f"Hours worked by Ringo: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
