
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
    x2 = model.addVar(name="x2")  # hours worked by Ringo

    # Objective function: minimize 6*x1 + 2*x2
    model.setObjective(6 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(12 * x1 + 19 * x2 >= 24)
    model.addConstr(13 * x1 + 12 * x2 >= 25)
    model.addConstr(9 * x1 - 2 * x2 >= 0)
    model.addConstr(12 * x1 + 19 * x2 <= 62)
    model.addConstr(13 * x1 + 12 * x2 <= 121)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
