
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, type=GRB.CONTINUOUS, name="grams_of_protein")
x1 = m.addVar(lb=0, type=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")
x2 = m.addVar(lb=0, type=GRB.CONTINUOUS, name="milligrams_of_vitamin_B1")
x3 = m.addVar(lb=0, type=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")
x4 = m.addVar(lb=0, type=GRB.INTEGER, name="milligrams_of_vitamin_C")


# Set objective function
m.setObjective(8*x0**2 + 9*x0*x1 + 5*x0*x2 + 4*x1*x3 + 3*x2**2 + 6*x2*x3 + 6*x2*x4 + 2*x1 + 2*x2 + 4*x3 + 9*x4, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x0 + 10*x1 + 7*x2 + 6*x3 + 7*x4 <= 172, "r0")
m.addConstr(4*x0 + 1*x1 + 11*x2 + 7*x3 + 3*x4 <= 79, "r1")
m.addConstr(7*x2 + 6*x3 >= 28, "c1")
m.addConstr(5*x0**2 + 10*x1**2 >= 25, "c2")
m.addConstr(10*x1 + 6*x3 >= 12, "c3")
m.addConstr(5*x0 + 7*x4 >= 34, "c4")
m.addConstr(7*x2**2 + 6*x3**2 + 7*x4**2 >= 33, "c5")
m.addConstr(5*x0**2 + 6*x3**2 + 7*x4**2 >= 33, "c6")
m.addConstr(5*x0 + 7*x2 + 7*x4 >= 33, "c7")
m.addConstr(5*x0 + 6*x3 + 7*x4 >= 33, "c9")
m.addConstr(7*x2 + 6*x3 + 7*x4 >= 32, "c11")
m.addConstr(5*x0 + 6*x3 + 7*x4 >= 32, "c12")
m.addConstr(5*x0**2 + 7*x2**2 + 7*x4**2 >= 32, "c13")
m.addConstr(5*x0 + 10*x1 + 7*x2 + 6*x3 + 7*x4 >= 32, "c14")
m.addConstr(x1 + 11*x2 >= 6, "c15")
m.addConstr(4*x0 + 11*x2 >= 6, "c16")
m.addConstr(4*x0 + 3*x4 >= 6, "c17")
m.addConstr(4*x0 + x1 + 11*x2 + 7*x3 + 3*x4 >= 6, "c18")
m.addConstr(-9*x2 + 10*x3 >= 0, "c19")
m.addConstr(-9*x0 + 8*x4 >= 0, "c20")
m.addConstr(5*x0 + 6*x3 <= 134, "c21")
m.addConstr(10*x1 + 6*x3 <= 47, "c22")
m.addConstr(5*x0**2 + 7*x2**2 <= 97, "c23")
m.addConstr(7*x2**2 + 6*x3**2 <= 116, "c24")
m.addConstr(6*x3 + 7*x4 <= 144, "c25")
m.addConstr(7*x2 + 7*x4 <= 148, "c26")
m.addConstr(10*x1**2 + 7*x2**2 <= 164, "c27")
m.addConstr(5*x0 + 7*x2 + 7*x4 <= 48, "c28")
m.addConstr(4*x0**2 + 3*x4**2 <= 65, "c29")
m.addConstr(4*x0 + x1 <= 45, "c30")
m.addConstr(4*x0 + 11*x2 <= 37, "c31")
m.addConstr(4*x0**2 + x1**2 + 11*x2**2 <= 27, "c32")
m.addConstr(11*x2 + 7*x3 + 3*x4 <= 53, "c33")
m.addConstr(4*x0**2 + 7*x3**2 + 3*x4**2 <= 65, "c34")
m.addConstr(x1**2 + 11*x2**2 + 3*x4**2 <= 31, "c35")
m.addConstr(x1 + 11*x2 + 7*x3 <= 21, "c36")
m.addConstr(4*x0**2 + 11*x2**2 + 7*x3**2 <= 26, "c37")
m.addConstr(x1 + 7*x3 + 3*x4 <= 42, "c38")
m.addConstr(4*x0**2 + x1**2 + 3*x4**2 <= 16, "c39")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
