
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="airborne_infantry_companies")


    # Set objective function
    model.setObjective(3*x0 + 6*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17*x0 + 16*x1 >= 11, "offensive_capability_min")
    model.addConstr(2*x0 + 17*x1 >= 12, "deployment_weight_min")
    model.addConstr(2*x0 - 8*x1 >= 0, "platoons_vs_companies")
    model.addConstr(17*x0 + 16*x1 <= 36, "offensive_capability_max")
    model.addConstr(2*x0 + 17*x1 <= 27, "deployment_weight_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"CBRN platoons: {x0.x}")
        print(f"Airborne infantry companies: {x1.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized correctly.")

