
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model, restricted to whole numbers
x0 = m.addVar(vtype=GRB.INTEGER, name="CBRN_platoons")
x1 = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")

# Set the objective function
m.setObjective(3*x0 + 6*x1, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(17*x0 + 16*x1 >= 11, "offensive_capability_min")
m.addConstr(2*x0 + 17*x1 >= 12, "deployment_weight_min")
m.addConstr(2*x0 - 8*x1 >= 0, "platoon_company_ratio")
m.addConstr(17*x0 + 16*x1 <= 36, "offensive_capability_max")
m.addConstr(2*x0 + 17*x1 <= 27, "deployment_weight_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"CBRN platoons: {x0.x}")
    print(f"Airborne infantry companies: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
