
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="airborne_infantry_companies", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(3*x1 + 6*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(17*x1 + 16*x2 >= 11, name="offensive_capability_rating_min")
    model.addConstr(2*x1 + 17*x2 >= 12, name="deployment_weight_min")
    model.addConstr(x1 - 4*x2 >= 0, name="CBRN_airborne_ratio")
    model.addConstr(17*x1 + 16*x2 <= 36, name="offensive_capability_rating_max")
    model.addConstr(2*x1 + 17*x2 <= 27, name="deployment_weight_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"CBRN platoons: {x1.varValue}")
        print(f"Airborne infantry companies: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
