
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B7
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # grams of fat
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin K
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B2


# Set objective function
m.setObjective(9*x0 + 1*x1 + 4*x2 + 6*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 6*x3 >= 39)
m.addConstr(5*x1 + 5*x2 >= 19)
m.addConstr(6*x0 + 5*x1 >= 27)
m.addConstr(6*x0 + 5*x2 >= 22)
m.addConstr(5*x2 + 6*x3 >= 18)
m.addConstr(6*x0 + 5*x1 + 6*x3 >= 33)
m.addConstr(6*x0 + 5*x1 + 5*x2 + 6*x3 >= 33)
m.addConstr(2*x0 + 13*x2 >= 25)
m.addConstr(12*x1 + 11*x3 >= 22)
m.addConstr(13*x2 + 11*x3 >= 34)
m.addConstr(12*x1 + 13*x2 >= 21)
m.addConstr(2*x0 + 12*x1 >= 35)
m.addConstr(2*x0 + 12*x1 + 11*x3 >= 21)
m.addConstr(2*x0 + 13*x2 + 11*x3 >= 21)
m.addConstr(2*x0 + 12*x1 + 13*x2 >= 21)
m.addConstr(2*x0 + 12*x1 + 11*x3 >= 17)
m.addConstr(2*x0 + 13*x2 + 11*x3 >= 17)
m.addConstr(2*x0 + 12*x1 + 13*x2 >= 17)
m.addConstr(2*x0 + 12*x1 + 11*x3 >= 35)
m.addConstr(2*x0 + 13*x2 + 11*x3 >= 35)
m.addConstr(2*x0 + 12*x1 + 13*x2 >= 35)
m.addConstr(2*x0 + 12*x1 + 13*x2 + 11*x3 >= 35)
m.addConstr(2*x0 + 3*x2 >= 21)
m.addConstr(8*x1 + 3*x2 >= 20)
m.addConstr(2*x0 + 5*x3 >= 16)
m.addConstr(8*x1 + 5*x3 >= 17)
m.addConstr(2*x0 + 8*x1 >= 20)
m.addConstr(2*x0 + 8*x1 + 3*x2 + 5*x3 >= 20)
m.addConstr(6*x1 - 9*x3 >= 0)
m.addConstr(6*x0 + 6*x3 <= 156)
m.addConstr(5*x1 + 6*x3 <= 139)
m.addConstr(5*x2 + 6*x3 <= 167)
m.addConstr(6*x0 + 5*x1 <= 104)
m.addConstr(6*x0 + 5*x2 <= 161)
m.addConstr(5*x1 + 5*x2 <= 177)
m.addConstr(5*x1 + 5*x2 + 6*x3 <= 123)
m.addConstr(2*x0 + 5*x3 <= 86)
m.addConstr(3*x2 + 5*x3 <= 23)
m.addConstr(2*x0 + 8*x1 <= 63)
m.addConstr(8*x1 + 3*x2 <= 57)
m.addConstr(8*x1 + 5*x3 <= 87)
m.addConstr(2*x0 + 3*x2 <= 64)
m.addConstr(2*x0 + 3*x2 + 5*x3 <= 45)
m.addConstr(2*x0 + 8*x1 + 3*x2 <= 66)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

