
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B1
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # milligrams of vitamin B12
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin B3
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # milligrams of vitamin C
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")  # milligrams of vitamin B5


# Set objective function
m.setObjective(9*x0 + 7*x1 + 5*x2 + 4*x3 + 2*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(26*x1 + 16*x3 >= 58)
m.addConstr(23*x0 + 26*x1 >= 55)
m.addConstr(26*x1 + 22*x2 >= 91)
m.addConstr(13*x0 + 26*x1 >= 24)
m.addConstr(4*x2 + 17*x3 >= 43)
m.addConstr(4*x2 + 20*x4 >= 24)
m.addConstr(13*x0 + 17*x3 >= 32)
m.addConstr(27*x0 + 10*x2 + 27*x3 >= 49)
m.addConstr(17*x0 + 17*x2 + 2*x4 >= 48)

# ... (rest of the constraints from the JSON)

m.addConstr(12 * x0 + 4 * x1 <= 368)
m.addConstr(4 * x1 + 10 * x2 <= 259)
m.addConstr(12 * x0 + 4 * x1 + 10 * x2 + 25 * x3 + 23 * x4 <= 259)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

