
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")


# Set objective function
m.setObjective(8.94*x0**2 + 2.9*x0*x1 + 7.25*x0*x2 + 9.45*x0*x3 + 3.53*x1**2 + 7.43*x1*x2 + 8.8*x1*x3 + 4.42*x2*x3 + 4.4*x3**2 + 6.95*x1 + 7.44*x2 + 2.62*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x2**2 + 3*x3**2 >= 77)
m.addConstr(6*x0 + 17*x2 >= 66)
m.addConstr(6*x0**2 + 3*x3**2 >= 47)
m.addConstr(2*x1**2 + 17*x2**2 >= 71)
m.addConstr(2*x1 + 17*x2 + 3*x3 >= 73)
m.addConstr(6*x0 + 2*x1 + 17*x2 + 3*x3 >= 73)
m.addConstr(16*x1**2 + 4*x2**2 >= 48)
m.addConstr(4*x2 + 21*x3 >= 35)
m.addConstr(5*x0 + 16*x1 >= 62)
m.addConstr(5*x0 + 21*x3 >= 33)
m.addConstr(5*x0**2 + 4*x2**2 >= 61)
m.addConstr(16*x1**2 + 21*x3**2 >= 75)
m.addConstr(5*x0**2 + 4*x2**2 + 21*x3**2 >= 57)
m.addConstr(5*x0 + 16*x1 + 4*x2 + 21*x3 >= 57)
m.addConstr(21*x0 + 18*x2 >= 58)
m.addConstr(6*x1**2 + 18*x2**2 >= 46)
m.addConstr(21*x0**2 + 6*x1**2 + 9*x3**2 >= 59)
m.addConstr(21*x0 + 18*x2 + 9*x3 >= 59)
m.addConstr(21*x0**2 + 6*x1**2 + 9*x3**2 >= 47)
m.addConstr(21*x0 + 18*x2 + 9*x3 >= 47)
m.addConstr(21*x0 + 6*x1 + 18*x2 + 9*x3 >= 47)
m.addConstr(20*x0**2 + 19*x1**2 >= 54)
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 91)
m.addConstr(20*x0**2 + 8*x2**2 + 9*x3**2 >= 91)
m.addConstr(20*x0**2 + 19*x1**2 + 8*x2**2 >= 91)
m.addConstr(20*x0 + 19*x1 + 9*x3 >= 91)
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 85)
m.addConstr(20*x0 + 8*x2 + 9*x3 >= 85)
m.addConstr(20*x0 + 19*x1 + 8*x2 >= 85)
m.addConstr(20*x0 + 19*x1 + 9*x3 >= 85)
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 88)
m.addConstr(20*x0**2 + 8*x2**2 + 9*x3**2 >= 88)
m.addConstr(20*x0**2 + 19*x1**2 + 8*x2**2 >= 88)
m.addConstr(20*x0**2 + 19*x1**2 + 9*x3**2 >= 88)
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 72)
m.addConstr(20*x0 + 8*x2 + 9*x3 >= 72)
m.addConstr(20*x0 + 19*x1 + 8*x2 >= 72)
m.addConstr(20*x0 + 19*x1 + 9*x3 >= 72)
m.addConstr(20*x0 + 19*x1 + 8*x2 + 9*x3 >= 72)
m.addConstr(4*x0 - 7*x2 >= 0)
m.addConstr(-x0**2 + 6*x1**2 >= 0)
m.addConstr(6*x0 + 3*x3 <= 188)
m.addConstr(2*x1 + 3*x3 <= 364)
m.addConstr(6*x0 + 2*x1 <= 135)
m.addConstr(6*x0 + 17*x2 + 3*x3 <= 102)
m.addConstr(6*x0 + 2*x1 + 3*x3 <= 117)
m.addConstr(5*x0**2 + 16*x1**2 + 21*x3**2 <= 226)
m.addConstr(6*x1 + 9*x3 <= 259)
m.addConstr(21*x0 + 9*x3 <= 304)
m.addConstr(21*x0**2 + 18*x2**2 <= 94)
m.addConstr(6*x1 + 18*x2 <= 123)
m.addConstr(18*x2 + 9*x3 <= 157)
m.addConstr(6*x1 + 18*x2 + 9*x3 <= 172)
m.addConstr(20*x0 + 9*x3 <= 418)
m.addConstr(20*x0**2 + 19*x1**2 + 9*x3**2 <= 410)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

