
import gurobi as gp

# Define variables
x0 = gp.Var('x0', lb=0)  # chicken drumsticks
x1 = gp.Var('x1', lb=0)  # apples
x2 = gp.Var('x2', lb=0)  # hamburgers
x3 = gp.Var('x3', lb=0)  # cheeseburgers

# Objective function
obj = 8.94*x0**2 + 2.9*x0*x1 + 7.25*x0*x2 + 9.45*x0*x3 + 3.53*x1**2 + 7.43*x1*x2 + 8.8*x1*x3 + 4.42*x2*x3 + 4.4*x3**2 + 6.95*x1 + 7.44*x2 + 2.62*x3

# Model
m = gp.Model()
m.addVars([x0, x1, x2, x3])
m.setObjective(obj, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(6*x0 + 2*x1 + 17*x2 + 3*x3 <= 397)  
m.addConstr(5*x0 + 16*x1 + 4*x2 + 21*x3 <= 319)  
m.addConstr(21*x0 + 6*x1 + 18*x2 + 9*x3 <= 327)  
m.addConstr(20*x0 + 19*x1 + 8*x2 + 9*x3 <= 491)

m.addConstr(x2**2 + x3**2 >= 77)  
m.addConstr(x0 + x2 >= 66)  
m.addConstr(x0**2 + x3**2 >= 47)  
m.addConstr(x1**2 + x2**2 >= 71)  
m.addConstr(x1 + x2 + x3 >= 73)  
m.addConstr(x0 + x1 + x2 + x3 >= 73)

m.addConstr(x1**2 + x2**2 >= 48)  
m.addConstr(x2 + x3 >= 35)  
m.addConstr(5*x0 + 16*x1 >= 62)  
m.addConstr(x0 + x3 >= 33)  
m.addConstr(x0**2 + x2**2 >= 61)  
m.addConstr(x1**2 + x3**2 >= 75)  
m.addConstr(x0**2 + x2**2 + x3**2 >= 57)  
m.addConstr(x0 + x1 + x2 + x3 >= 57)

m.addConstr(21*x0 + 18*x2 >= 58)  
m.addConstr(6*x1 + 18*x2 >= 46)  
m.addConstr(x0**2 + x1**2 + x3**2 >= 59)  
m.addConstr(x0 + x2 + x3 >= 59)  
m.addConstr(x0**2 + x1**2 + x3**2 >= 47)  
m.addConstr(x0 + x2 + x3 >= 47)  
m.addConstr(x0 + x1 + x2 + x3 >= 47)

m.addConstr(20*x0**2 + 19*x1**2 >= 54)  
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 91)  
m.addConstr(20*x0**2 + 8*x2**2 + 9*x3**2 >= 91)  
m.addConstr(20*x0**2 + 19*x1**2 + 8*x2**2 >= 91)  
m.addConstr(20*x0 + 19*x1 + 9*x3 >= 91)  
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 85)  
m.addConstr(20*x0 + 8*x2 + 9*x3 >= 85)  
m.addConstr(20*x0 + 19*x1 + 8*x2 >= 85)  
m.addConstr(20*x0 + 19*x1 + 9*x3 >= 85)  
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 88)  
m.addConstr(20*x0**2 + 8*x2**2 + 9*x3**2 >= 88)  
m.addConstr(20*x0**2 + 19*x1**2 + 8*x2**2 >= 88)  
m.addConstr(20*x0**2 + 19*x1**2 + 9*x3**2 >= 88)  
m.addConstr(19*x1 + 8*x2 + 9*x3 >= 72)  
m.addConstr(20*x0 + 8*x2 + 9*x3 >= 72)  
m.addConstr(20*x0 + 19*x1 + 8*x2 >= 72)  
m.addConstr(20*x0 + 19*x1 + 9*x3 >= 72)  
m.addConstr(20*x0 + 19*x1 + 8*x2 + 9*x3 >= 72)

m.addConstr(4*x0 - 7*x2 >= 0)  
m.addConstr(-x0**2 + 6*x1**2 >= 0)  
m.addConstr(6*x0 + 3*x3 <= 188)  
m.addConstr(x1 + 3*x3 <= 364)  
m.addConstr(6*x0 + 19*x1 <= 135)  
m.addConstr(6*x0 + 17*x2 + 3*x3 <= 102)  
m.addConstr(6*x0 + 19*x1 + 3*x3 <= 117)

m.addConstr(5*x0**2 + 16*x1**2 + 9*x3**2 <= 226)  
m.addConstr(6*x1 + 9*x3 <= 259)  
m.addConstr(21*x0 + 9*x3 <= 304)  
m.addConstr(21*x0 + 18*x2 <= 94)  
m.addConstr(6*x1 + 18*x2 <= 123)  
m.addConstr(18*x2 + 9*x3 <= 157)  
m.addConstr(6*x1 + 18*x2 + 9*x3 <= 172)

m.addConstr(20*x0 + 9*x3 <= 418)  
m.addConstr(20*x0**2 + 19*x1**2 + 9*x3**2 <= 410)

try:
    m.optimize()
    if m.status == gp.GRB.Status.OPTIMAL:
        print('Objective: %g' % m.objVal)
        print('x0: %g' % x0.varValue)
        print('x1: %g' % x1.varValue)
        print('x2: %g' % x2.varValue)
        print('x3: %g' % x3.varValue)
    else:
        print('No solution found')
except gp.GRB.Error as e:
    print('Error:', e)
