
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("Work_Optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean_hours")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura_hours")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Mary_hours")


    # Set objective function
    m.setObjective(4*x0 + 5*x1 + 4*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(19*x0 + 16*x2 >= 22, "c0")
    m.addConstr(19*x0 + 8*x1 >= 30, "c1")
    m.addConstr(8*x1 + 16*x2 >= 27, "c2")
    m.addConstr(19*x0 + 8*x1 <= 39, "c3")
    m.addConstr(8*x1 + 16*x2 <= 91, "c4")
    m.addConstr(19*x0 + 8*x1 + 16*x2 <= 91, "c5")
    m.addConstr(12*x0 + 2*x2 <= 90, "c6")
    m.addConstr(12*x0 + 14*x1 <= 56, "c7")
    m.addConstr(12*x0 + 14*x1 + 2*x2 <= 56, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
