
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")

# Define objective function
m.setObjective(4*x0 + 5*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(19*x0 + 16*x2 >= 22)
m.addConstr(19*x0 + 8*x1 >= 30)
m.addConstr(8*x1 + 16*x2 >= 27)
m.addConstr(19*x0 + 8*x1 <= 39)
m.addConstr(8*x1 + 16*x2 <= 91)
m.addConstr(19*x0 + 8*x1 + 16*x2 <= 91)
m.addConstr(12*x0 + 2*x2 <= 90)
m.addConstr(12*x0 + 14*x1 <= 56)
m.addConstr(12*x0 + 14*x1 + 2*x2 <= 56)

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print("Objective:", m.objVal)
