
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="3D_printers")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")


    # Set objective function
    m.setObjective(6*x0*x1 + 8*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 9*x1 >= 33, "cost_lower_bound")
    m.addConstr(6*x0 + 9*x1 <= 70, "cost_upper_bound")
    m.addConstr(20*x0 + 9*x1 >= 84, "weight_lower_bound")
    m.addConstr(20*x0 + 9*x1 <= 168, "weight_upper_bound")
    m.addConstr(x0 - 4*x1 >= 0, "ratio_constraint")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"3D printers: {x0.x}")
        print(f"Packs of paper: {x1.x}")
        print(f"Objective Value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check variable definitions and constraint formulations.")

