
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="3D_printers")
x1 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper")

# Set objective function
m.setObjective(6 * x0 * x1 + 8 * x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x0 + 9 * x1 <= 100, "dollar_cost")
m.addConstr(20 * x0 + 9 * x1 <= 178, "weight")
m.addConstr(6 * x0 + 9 * x1 >= 33, "min_dollar_spend")
m.addConstr(20 * x0 + 9 * x1 >= 84, "min_weight")
m.addConstr(x0 - 4 * x1 >= 0, "printer_paper_ratio")
m.addConstr(6 * x0 + 9 * x1 <= 70, "max_dollar_spend")
m.addConstr(20 * x0 + 9 * x1 <= 168, "max_weight")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"3D printers: {x0.x}")
    print(f"Packs of paper: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
