
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="3D_printers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(6 * x1 * x2 + 8 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x1 + 9 * x2 >= 33)
    model.addConstr(20 * x1 + 9 * x2 >= 84)
    model.addConstr(x1 - 4 * x2 >= 0)
    model.addConstr(6 * x1 + 9 * x2 <= 70)
    model.addConstr(20 * x1 + 9 * x2 <= 168)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"3D printers: {x1.varValue}")
        print(f"Packs of paper: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
