
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimize_work_hours")

    # Create variables
    laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
    hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
    bobby_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")

    # Set objective function
    m.setObjective(6.81 * laura_hours + 3.82 * hank_hours + 7.83 * bobby_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * laura_hours + 19 * hank_hours >= 60, "c1")
    m.addConstr(19 * hank_hours + 9 * bobby_hours <= 192, "c2")
    m.addConstr(2 * laura_hours + 9 * bobby_hours <= 98, "c3")
    m.addConstr(2 * laura_hours + 19 * hank_hours <= 109, "c4")
    m.addConstr(2 * laura_hours + 19 * hank_hours + 9 * bobby_hours <= 109, "c5")
    m.addConstr(16 * laura_hours + 15 * bobby_hours <= 139, "c6")
    m.addConstr(16 * laura_hours + 16 * hank_hours <= 74, "c7")
    m.addConstr(16 * laura_hours + 16 * hank_hours + 15 * bobby_hours <= 74, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('Hank Hours: %g' % hank_hours.x)
        print('Bobby Hours: %g' % bobby_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
