
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Laura", lb=0)  # Laura
x1 = m.addVar(name="hours_worked_by_Hank", lb=0)   # Hank
x2 = m.addVar(name="hours_worked_by_Bobby", lb=0)  # Bobby

# Objective function
m.setObjective(6.81 * x0 + 3.82 * x1 + 7.83 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(2 * x0 <= 197, name="Laura_likelihood_to_quit")
m.addConstr(16 * x0 <= 146, name="Laura_organization_score")
m.addConstr(19 * x1 <= 197, name="Hank_likelihood_to_quit")
m.addConstr(16 * x1 <= 146, name="Hank_organization_score")
m.addConstr(9 * x2 <= 197, name="Bobby_likelihood_to_quit")
m.addConstr(15 * x2 <= 146, name="Bobby_organization_score")

m.addConstr(2 * x0 + 19 * x1 >= 60, name="Laura_Hank_likelihood_to_quit")
m.addConstr(19 * x1 + 9 * x2 <= 192, name="Hank_Bobby_likelihood_to_quit")
m.addConstr(2 * x0 + 9 * x2 <= 98, name="Laura_Bobby_likelihood_to_quit")
m.addConstr(2 * x0 + 19 * x1 <= 109, name="Laura_Hank_likelihood_to_quit_max")
m.addConstr(2 * x0 + 19 * x1 + 9 * x2 <= 109, name="all_likelihood_to_quit")

m.addConstr(16 * x0 + 15 * x2 <= 139, name="Laura_Bobby_organization_score")
m.addConstr(16 * x0 + 16 * x1 <= 74, name="Laura_Hank_organization_score")
m.addConstr(16 * x0 + 16 * x1 + 15 * x2 <= 74, name="all_organization_score")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Laura: ", x0.varValue)
    print("Hours worked by Hank: ", x1.varValue)
    print("Hours worked by Bobby: ", x2.varValue)
else:
    print("The model is infeasible")
