
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_k = m.addVar(vtype=GRB.INTEGER, name="vitamin_k")
    vitamin_b3 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b3")

    # Set objective function
    m.setObjective(3.72*vitamin_k**2 + 4.42*vitamin_k*vitamin_b3 + 7.14*vitamin_b3**2 + 5.68*vitamin_k + 3.49*vitamin_b3, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*vitamin_k + 8*vitamin_b3 <= 104, "energy_stability_index_upper_bound")
    m.addConstr(vitamin_k**2 + vitamin_b3**2 >= 51, "combined_energy_stability_index_lower_bound_squared")
    m.addConstr(8*vitamin_k + 8*vitamin_b3 >= 51, "combined_energy_stability_index_lower_bound")
    m.addConstr(-2*vitamin_k + 5*vitamin_b3 >= 0, "constraint4")
    m.addConstr(8*vitamin_k + 8*vitamin_b3 <= 67, "combined_energy_stability_index_upper_bound")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_k: %g' % vitamin_k.x)
        print('vitamin_b3: %g' % vitamin_b3.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
