
import gurobipy as gp

# Create a new model
m = gp.Model("Vitamin_Optimization")

# Define variables
x1 = m.addVar(name="milligrams_of_vitamin_K", vtype=gp.GRB.INTEGER)  # integer
x2 = m.addVar(name="milligrams_of_vitamin_B3")  # continuous

# Objective function
m.setObjective(3.72*x1**2 + 4.42*x1*x2 + 7.14*x2**2 + 5.68*x1 + 3.49*x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(64*(x1**2 + x2**2) >= 51, name="energy_stability_squared")
m.addConstr(8*x1 + 8*x2 >= 51, name="energy_stability_min")
m.addConstr(8*x1 + 8*x2 <= 67, name="energy_stability_max")
m.addConstr(-2*x1 + 5*x2 >= 0, name="vitamin_ratio")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of Vitamin K: {x1.varValue}")
    print(f"Milligrams of Vitamin B3: {x2.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("The model is infeasible or unbounded.")
