
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of vitamin B12
x1 = m.addVar(vtype=GRB.INTEGER, name="x1") # grams of fat
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") # milligrams of vitamin B9
x3 = m.addVar(vtype=GRB.INTEGER, name="x3") # milligrams of vitamin D


# Set objective function
m.setObjective(3.43*x0**2 + 3.8*x0*x1 + 3.56*x0*x2 + 9.65*x1**2 + 8.4*x2**2 + 3.75*x2*x3 + 6.9*x2 + 4.4*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 16*x1 + 4*x2 + 16*x3 <= 349, "r0")
m.addConstr(8*x0 + 3*x1 + 20*x2 + 12*x3 <= 250, "r1")
m.addConstr(11*x0 + 1*x1 + 1*x2 + 19*x3 <= 156, "r2")
m.addConstr(4*x0 + 7*x1 + 12*x2 + 6*x3 <= 292, "r3")
m.addConstr(18*x0 + 11*x1 + 5*x2 + 1*x3 <= 199, "r4")
m.addConstr(8*x0 + 20*x2 + 12*x3 >= 54, "c1")
m.addConstr(8*x0**2 + 3*x1**2 + 12*x3**2 >= 54, "c2")
m.addConstr(x0 + x2 + x3 >= 50, "c3")
m.addConstr(8*x0 + 3*x1 + 12*x3 >= 50, "c4")
m.addConstr(x1**2 + x2**2 >= 38, "c5")
m.addConstr(x1 + 19*x3 >= 17, "c6")
m.addConstr(x2**2 + 19*x3**2 >= 17, "c7")
m.addConstr(11*x0 + x1 >= 17, "c8")
m.addConstr(11*x0 + 19*x3 >= 18, "c9")
m.addConstr(4*x0 + 6*x3 >= 45, "c10")
m.addConstr(12*x2 + 6*x3 >= 53, "c11")
m.addConstr(4*x0 + 7*x1 >= 48, "c12")
m.addConstr(7*x1 + 6*x3 >= 59, "c13")
m.addConstr(7*x1 + 12*x2 >= 65, "c14")
m.addConstr(18*x0 + 11*x1 + 5*x2 >= 46, "c15")
m.addConstr(16*x1**2 + 4*x2**2 <= 232, "c16")
m.addConstr(3*x0**2 + 16*x1**2 <= 101, "c17")
m.addConstr(3*x0**2 + 4*x2**2 <= 309, "c18")
m.addConstr(3*x0 + 16*x1 + 4*x2 + 16*x3 <= 309, "c19")
m.addConstr(3*x1**2 + 20*x2**2 <= 70, "c20")
m.addConstr(20*x2 + 12*x3 <= 182, "c21")
m.addConstr(8*x0**2 + 3*x1**2 <= 147, "c22")
m.addConstr(8*x0 + 3*x1 + 12*x3 <= 139, "c23")
m.addConstr(8*x0 + 20*x2 + 12*x3 <= 106, "c24")
m.addConstr(8*x0 + 3*x1 + 20*x2 <= 100, "c25")
m.addConstr(3*x1**2 + 20*x2**2 + 12*x3**2 <= 138, "c26")
m.addConstr(8*x0 + 3*x1 + 20*x2 + 12*x3 <= 138, "c27")
m.addConstr(11*x0 + 19*x3 <= 133, "c28")
m.addConstr(x2**2 + 19*x3**2 <= 95, "c29")
m.addConstr(11*x0**2 + x1**2 <= 123, "c30")
m.addConstr(11*x0 + x2 <= 87, "c31")
m.addConstr(11*x0 + x1 + x2 + 19*x3 <= 87, "c32")
m.addConstr(4*x0 + 6*x3 <= 213, "c33")
m.addConstr(4*x0 + 12*x2 <= 201, "c34")
m.addConstr(12*x2**2 + 6*x3**2 <= 180, "c35")
m.addConstr(7*x1 + 12*x2 <= 171, "c36")
m.addConstr(4*x0**2 + 7*x1**2 + 6*x3**2 <= 171, "c37")
m.addConstr(4*x0 + 7*x1 + 12*x2 + 6*x3 <= 171, "c38")
m.addConstr(18*x0 + 11*x1 <= 198, "c39")
m.addConstr(18*x0 + x3 <= 78, "c40")
m.addConstr(18*x0**2 + 5*x2**2 <= 195, "c41")
m.addConstr(11*x1**2 + x3**2 <= 169, "c42")
m.addConstr(5*x2 + x3 <= 118, "c43")
m.addConstr(18*x0 + 11*x1 + 5*x2 + x3 <= 118, "c44")


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

