
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
chicken = m.addVar(lb=0, name="chicken")
bananas = m.addVar(lb=0, name="bananas")
protein_bars = m.addVar(lb=0, name="protein_bars")

# Set objective function
m.setObjective(5*chicken + 3*bananas + 8*protein_bars, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10*chicken + 1*bananas >= 12, "protein_constraint1")
m.addConstr(1*bananas + 6*protein_bars >= 9, "protein_constraint2")
m.addConstr(10*chicken + 6*protein_bars >= 11, "protein_constraint3")
m.addConstr(10*chicken + 1*bananas + 6*protein_bars >= 11, "protein_constraint4")
m.addConstr(4*chicken + 1*bananas >= 9, "cost_constraint1")
m.addConstr(1*bananas + 8*protein_bars >= 8, "cost_constraint2")
m.addConstr(4*chicken + 1*bananas + 8*protein_bars >= 8, "cost_constraint3")
m.addConstr(-5*chicken + 4*bananas >= 0, "constraint4")
m.addConstr(10*chicken + 1*bananas <= 27, "constraint5")
m.addConstr(4*chicken + 1*bananas <= 36, "constraint6")
m.addConstr(4*chicken + 8*protein_bars <= 52, "constraint7")
m.addConstr(4*chicken + 1*bananas + 8*protein_bars <= 56, "constraint8")
m.addConstr(10 * chicken <= 61, "protein_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chicken:', chicken.x)
    print('bananas:', bananas.x)
    print('protein_bars:', protein_bars.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

