
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="chicken_breasts", lb=0)
x1 = model.addVar(name="bananas", lb=0)
x2 = model.addVar(name="protein_bars", lb=0)

# Set the objective function
model.setObjective(5*x0 + 3*x1 + 8*x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(10*x0 + x1 >= 12)
model.addConstr(x1 + 6*x2 >= 9)
model.addConstr(10*x0 + 6*x2 >= 11)
model.addConstr(10*x0 + x1 + 6*x2 >= 11)
model.addConstr(4*x0 + x1 >= 9)
model.addConstr(x1 + 8*x2 >= 8)
model.addConstr(4*x0 + x1 + 8*x2 >= 8)
model.addConstr(-5*x0 + 4*x1 >= 0)
model.addConstr(10*x0 + x1 <= 27)
model.addConstr(4*x0 + x1 <= 36)
model.addConstr(4*x0 + 8*x2 <= 52)
model.addConstr(4*x0 + x1 + 8*x2 <= 56)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Chicken breasts: ", x0.x)
    print("Bananas: ", x1.x)
    print("Protein bars: ", x2.x)
else:
    print("The model is infeasible")
