
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=["system administrators", "security engineers", "Mbps bandwidth allocated to monitoring", "deployed decoys", "SOC operators", "patches per day"])


# Set objective function
m.setObjective(9*x[0] + 7*x[1] + 6*x[2] + 7*x[3] + 4*x[4] + 2*x[5], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(26*x[0] + 19*x[1] + 21*x[2] + 16*x[3] + 1*x[4] + 28*x[5] <= 379, "r0")
m.addConstr(15*x[0] + 22*x[1] + 25*x[2] + 13*x[3] + 12*x[4] + 10*x[5] <= 675, "r1")
m.addConstr(22*x[0] + 15*x[1] + 26*x[2] + 25*x[3] + 5*x[4] + 5*x[5] <= 935, "r2")
m.addConstr(16*x[3] + 1*x[4] >= 45, "c4")
m.addConstr(19*x[1] + 21*x[2] >= 27, "c5")
m.addConstr(21*x[2] + 28*x[5] >= 24, "c6")
m.addConstr(19*x[1] + 16*x[3] >= 32, "c7")
m.addConstr(22*x[1] + 12*x[4] + 10*x[5] >= 66, "c8")
m.addConstr(15*x[0] + 22*x[1] + 13*x[3] >= 66, "c9")
m.addConstr(22*x[1] + 25*x[2] + 10*x[5] >= 66, "c10")
m.addConstr(25*x[2] + 13*x[3] + 10*x[5] >= 66, "c11")
m.addConstr(22*x[1] + 12*x[4] + 10*x[5] >= 109, "c12")
m.addConstr(15*x[0] + 22*x[1] + 13*x[3] >= 109, "c13")
m.addConstr(22*x[1] + 25*x[2] + 10*x[5] >= 109, "c14")
m.addConstr(25*x[2] + 13*x[3] + 10*x[5] >= 109, "c15")
m.addConstr(22*x[1] + 12*x[4] + 10*x[5] >= 94, "c16")
m.addConstr(15*x[0] + 22*x[1] + 13*x[3] >= 94, "c17")
m.addConstr(22*x[1] + 25*x[2] + 10*x[5] >= 94, "c18")
m.addConstr(25*x[2] + 13*x[3] + 10*x[5] >= 94, "c19")
m.addConstr(22*x[1] + 12*x[4] + 10*x[5] >= 58, "c20")
m.addConstr(15*x[0] + 22*x[1] + 13*x[3] >= 58, "c21")
m.addConstr(22*x[1] + 25*x[2] + 10*x[5] >= 58, "c22")
m.addConstr(25*x[2] + 13*x[3] + 10*x[5] >= 58, "c23")
m.addConstr(25*x[3] + 5*x[4] >= 122, "c24")
m.addConstr(15*x[1] + 26*x[2] >= 134, "c25")
m.addConstr(25*x[3] + 5*x[5] >= 123, "c26")


# ... (rest of the constraints)

m.addConstr(22 * x[0] + 15 * x[1] + 26 * x[2] + 25 * x[3] + 5 * x[4] + 5 * x[5] <= 567, "total_power")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

