
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Bill")
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="hours worked by Jean")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Paul")


    # Set objective function
    model.setObjective(5.91 * x0 + 2.81 * x1 + 9.29 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4.56 * x0 + 0.22 * x2 >= 13, "c0")
    model.addConstr(2.68 * x0 + 0.18 * x2 >= 19, "c1")
    model.addConstr(0.38 * x1 + 0.18 * x2 >= 11, "c2")
    model.addConstr(5.16 * x1 + 0.83 * x2 >= 9, "c3")
    model.addConstr(2.54 * x0 + 5.16 * x1 >= 12, "c4")
    model.addConstr(3.6 * x1 + 0.22 * x2 <= 22, "c5")
    model.addConstr(4.56 * x0 + 3.6 * x1 + 0.22 * x2 <= 22, "c6")
    model.addConstr(2.68 * x0 + 0.18 * x2 <= 50, "c7")
    model.addConstr(2.68 * x0 + 0.38 * x1 + 0.18 * x2 <= 50, "c8")
    model.addConstr(2.54 * x0 + 0.83 * x2 <= 26, "c9")
    model.addConstr(5.16 * x1 + 0.83 * x2 <= 25, "c10")
    model.addConstr(2.54 * x0 + 5.16 * x1 + 0.83 * x2 <= 25, "c11")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
