
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gurobi.GRB.INTEGER, lb=0)  # hours worked by Bill
x1 = m.addVar(name="x1", vtype=gurobi.GRB.CONTINUOUS, lb=0)  # hours worked by Jean
x2 = m.addVar(name="x2", vtype=gurobi.GRB.INTEGER, lb=0)  # hours worked by Paul

# Define the objective function
m.setObjective(5.91*x0 + 2.81*x1 + 9.29*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.56*x0 >= 4.56)
m.addConstr(2.68*x0 >= 2.68)
m.addConstr(2.54*x0 >= 2.54)
m.addConstr(3.6*x1 >= 3.6)
m.addConstr(0.38*x1 >= 0.38)
m.addConstr(5.16*x1 >= 5.16)
m.addConstr(0.22*x2 >= 0.22)
m.addConstr(0.18*x2 >= 0.18)
m.addConstr(0.83*x2 >= 0.83)
m.addConstr(4.56*x0 + 0.22*x2 >= 13)
m.addConstr(2.68*x0 + 0.18*x2 >= 19)
m.addConstr(0.38*x1 + 0.18*x2 >= 11)
m.addConstr(5.16*x1 + 0.83*x2 >= 9)
m.addConstr(2.54*x0 + 5.16*x1 >= 12)
m.addConstr(3.6*x1 + 0.22*x2 <= 22)
m.addConstr(4.56*x0 + 3.6*x1 + 0.22*x2 <= 22)
m.addConstr(2.68*x0 + 0.18*x2 <= 50)
m.addConstr(2.68*x0 + 0.38*x1 + 0.18*x2 <= 50)
m.addConstr(2.54*x0 + 0.83*x2 <= 26)
m.addConstr(5.16*x1 + 0.83*x2 <= 25)
m.addConstr(2.54*x0 + 5.16*x1 + 0.83*x2 <= 25)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
