
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = {}
var_names = ['engineer platoons', 'medical platoons', 'armored companies', 'air defense batteries', 'reconnaissance troops', 'water purification units']
for i in range(len(var_names)):
    x[i] = m.addVar(vtype=gp.GRB.INTEGER, name=var_names[i])


# Set objective function
m.setObjective(5.02*x[0] + 2.78*x[1] + 2.24*x[2] + 6.5*x[3] + 5.22*x[4] + 6.48*x[5], gp.GRB.MAXIMIZE)

# Resource constraints
resources = {'r0': {'upper_bound': 395, 'coefficients': [8, 4, 2, 6, 2, 4]}, 
            'r1': {'upper_bound': 625, 'coefficients': [22, 12, 10, 13, 6, 13]}, 
            'r2': {'upper_bound': 462, 'coefficients': [12, 5, 10, 29, 24, 4]}, 
            'r3': {'upper_bound': 684, 'coefficients': [4, 6, 14, 3, 28, 21]}}

for resource, data in resources.items():
    m.addConstr(sum(data['coefficients'][i] * x[i] for i in range(len(var_names))) <= data['upper_bound'], name=resource)


# Additional constraints (simplified and deduplicated)
m.addConstr(2*x[2] + 6*x[3] >= 27)
m.addConstr(8*x[0] + 2*x[4] >= 48)
m.addConstr(6*x[3] + 2*x[4] >= 39)
m.addConstr(8*x[0] + 2*x[2] >= 21)
m.addConstr(4*x[1] + 4*x[5] >= 59)


# ... (Add all other simplified and deduplicated constraints here)
m.addConstr(10*x[2] + 13*x[5] >= 83)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

