 
import gurobi

model = gurobi.Model()

x0 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="engineer_platoons")
x1 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="medical_platoons")
x2 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="armored_companies")
x3 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="air_defense_batteries")
x4 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="reconnaissance_troops")
x5 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="water_purification_units")

model.setObjective(5.02*x0 + 2.78*x1 + 2.24*x2 + 6.5*x3 + 5.22*x4 + 6.48*x5, gurobi.GRB.MAXIMIZE)

model.addConstr(8*x0 + 4*x1 + 2*x2 + 6*x3 + 2*x4 + 4*x5 <= 395)
model.addConstr(22*x0 + 12*x1 + 10*x2 + 13*x3 + 6*x4 + 13*x5 <= 625)
model.addConstr(12*x0 + 5*x1 + 10*x2 + 29*x3 + 24*x4 + 4*x5 <= 462)
model.addConstr(4*x0 + 6*x1 + 14*x2 + 3*x3 + 28*x4 + 21*x5 <= 684)

model.addConstr(8*x0 + 2*x2 + 6*x3 >= 27)
model.addConstr(8*x0 + 4*x1 + 2*x4 >= 48)
model.addConstr(8*x0 + 4*x1 + 6*x3 + 2*x4 >= 39)
model.addConstr(8*x0 + 2*x2 >= 21)
model.addConstr(4*x1 + 4*x5 >= 59)
model.addConstr(6*x3 + 2*x4 + 4*x5 >= 43)
model.addConstr(4*x1 + 2*x2 + 2*x4 >= 43)
model.addConstr(8*x0 + 2*x2 + 6*x3 >= 43)
model.addConstr(8*x0 + 4*x1 + 6*x3 >= 43)
model.addConstr(2*x2 + 6*x3 + 4*x5 >= 43)
model.addConstr(8*x0 + 4*x1 + 2*x2 >= 43)
model.addConstr(8*x0 + 6*x3 + 2*x4 >= 43)
model.addConstr(2*x2 + 6*x3 + 4*x5 >= 43)
model.addConstr(8*x0 + 4*x1 + 2*x4 >= 56)
model.addConstr(4*x1 + 2*x2 + 2*x4 >= 56)
model.addConstr(2*x2 + 6*x3 + 4*x5 >= 56)
model.addConstr(8*x0 + 6*x3 + 2*x4 >= 56)
model.addConstr(8*x0 + 4*x1 + 2*x2 >= 56)
model.addConstr(8*x0 + 4*x1 + 6*x3 >= 56)
model.addConstr(8*x0 + 2*x2 + 6*x3 >= 56)
model.addConstr(4*x1 + 2*x2 + 4*x5 >= 56)

model.optimize()

if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Engineer platoons: ", x0.x)
    print("Medical platoons: ", x1.x)
    print("Armored companies: ", x2.x)
    print("Air defense batteries: ", x3.x)
    print("Reconnaissance troops: ", x4.x)
    print("Water purification units: ", x5.x)
else:
    print("Model is infeasible")
