
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")


# Set objective function
m.setObjective(6.14 * x0 + 5.7 * x1 + 4.56 * x2 + 8.45 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21 * x1 + 1 * x3 >= 49)
m.addConstr(5 * x0 + 34 * x2 >= 42)
m.addConstr(5 * x0 + 21 * x1 >= 21)
m.addConstr(5 * x0 + 1 * x3 >= 26)
m.addConstr(12 * x0 + 30 * x1 >= 83)
m.addConstr(5 * x0 + 21 * x1 <= 109)
m.addConstr(5 * x0 + 34 * x2 <= 125)
m.addConstr(21 * x1 + 1 * x3 <= 195)
m.addConstr(5 * x0 + 1 * x3 <= 206)
m.addConstr(34 * x2 + 1 * x3 <= 229)
m.addConstr(5 * x0 + 21 * x1 + 34 * x2 + 1 * x3 <= 229)
m.addConstr(15 * x2 + 13 * x3 <= 335)
m.addConstr(12 * x0 + 15 * x2 <= 446)
m.addConstr(12 * x0 + 13 * x3 <= 146)
m.addConstr(12 * x0 + 30 * x1 <= 226)
m.addConstr(30 * x1 + 15 * x2 <= 352)
m.addConstr(12 * x0 + 30 * x1 + 15 * x2 + 13 * x3 <= 352)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rotisserie Chickens: {x0.x}")
    print(f"Oranges: {x1.x}")
    print(f"Blueberry Pies: {x2.x}")
    print(f"Green Beans: {x3.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

