
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # rotisserie chickens
    x1 = model.addVar(name="x1", lb=0)  # oranges
    x2 = model.addVar(name="x2", lb=0)  # blueberry pies
    x3 = model.addVar(name="x3", lb=0)  # green beans

    # Define the objective function
    model.setObjective(6.14 * x0 + 5.7 * x1 + 4.56 * x2 + 8.45 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(21 * x1 + x3 >= 49)
    model.addConstr(5 * x0 + 34 * x2 >= 42)
    model.addConstr(5 * x0 + 21 * x1 >= 21)
    model.addConstr(5 * x0 + x3 >= 26)
    model.addConstr(12 * x0 + 30 * x1 >= 83)
    model.addConstr(5 * x0 + 21 * x1 <= 109)
    model.addConstr(5 * x0 + 34 * x2 <= 125)
    model.addConstr(21 * x1 + x3 <= 195)
    model.addConstr(5 * x0 + x3 <= 206)
    model.addConstr(34 * x2 + x3 <= 229)
    model.addConstr(5 * x0 + 21 * x1 + 34 * x2 + x3 <= 229)
    model.addConstr(15 * x2 + 13 * x3 <= 335)
    model.addConstr(12 * x0 + 15 * x2 <= 446)
    model.addConstr(12 * x0 + 13 * x3 <= 146)
    model.addConstr(12 * x0 + 30 * x1 <= 226)
    model.addConstr(30 * x1 + 15 * x2 <= 352)
    model.addConstr(12 * x0 + 30 * x1 + 15 * x2 + 13 * x3 <= 352)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0 (rotisserie chickens): ", x0.varValue)
        print("x1 (oranges): ", x1.varValue)
        print("x2 (blueberry pies): ", x2.varValue)
        print("x3 (green beans): ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
