
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    dale_hours = model.addVar(lb=0, name="dale_hours")
    john_hours = model.addVar(lb=0, name="john_hours")
    george_hours = model.addVar(lb=0, name="george_hours")


    # Set objective function
    model.setObjective(2.25*dale_hours**2 + 5.18*dale_hours*john_hours + 4.6*dale_hours*george_hours + 2.19*john_hours*george_hours + 8.59*dale_hours + 9.2*john_hours + 10.0*george_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5*dale_hours**2 + 20*george_hours**2 >= 29)
    model.addConstr(5*dale_hours + 7*john_hours + 20*george_hours >= 32)
    model.addConstr(7*john_hours + 20*george_hours <= 71)
    model.addConstr(5*dale_hours + 7*john_hours <= 72)
    model.addConstr(5*dale_hours + 7*john_hours + 20*george_hours <= 175)
    model.addConstr(16*dale_hours + 16*john_hours <= 179)
    model.addConstr(16*dale_hours + 16*george_hours <= 136)
    model.addConstr(16*dale_hours + 16*john_hours + 16*george_hours <= 200)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Dale Hours: %g' % dale_hours.x)
        print('John Hours: %g' % john_hours.x)
        print('George Hours: %g' % george_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
