
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='hours_worked_by_Dale', lb=0)
x1 = model.addVar(name='hours_worked_by_John', lb=0)
x2 = model.addVar(name='hours_worked_by_George', lb=0)

# Define the objective function
model.setObjective(2.25*x0**2 + 5.18*x0*x1 + 4.6*x0*x2 + 2.19*x1*x2 + 8.59*x0 + 9.2*x1 + 10.0*x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(5*x0**2 + 20*x2**2 >= 29)
model.addConstr(5*x0 + 7*x1 + 20*x2 >= 32)
model.addConstr(7*x1 + 20*x2 <= 71)
model.addConstr(5*x0 + 7*x1 <= 72)
model.addConstr(5*x0 + 7*x1 + 20*x2 <= 175)
model.addConstr(16*x0 + 16*x1 <= 179)
model.addConstr(16*x0 + 16*x2 <= 136)
model.addConstr(16*x0 + 16*x1 + 16*x2 <= 200)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Optimal solution found.')
    print('Hours worked by Dale:', x0.varValue)
    print('Hours worked by John:', x1.varValue)
    print('Hours worked by George:', x2.varValue)
    print('Objective function value:', model.objVal)
else:
    print('No optimal solution found.')
