
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pizza = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pizza")
strawberries = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")
ravioli = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")
chicken = m.addVar(lb=0, vtype=GRB.INTEGER, name="chicken")


# Set objective function
m.setObjective(8*pizza**2 + 9*pizza*strawberries + 2*pizza*ravioli + 6*pizza*chicken + 5*strawberries**2 + 7*strawberries*ravioli + 5*strawberries*chicken + 3*ravioli**2 + 8*ravioli*chicken + 9*chicken**2 + 9*pizza + 3*strawberries + 6*ravioli + 4*chicken, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*pizza + 4*strawberries + 9*ravioli <= 158, "c0")
m.addConstr(pizza + 3*strawberries + 20*ravioli + 8*chicken <= 80, "c1")
m.addConstr(3*pizza + 15*strawberries + 17*ravioli + 16*chicken <= 141, "c2")
m.addConstr(7*pizza + 4*strawberries + 9*ravioli >= 27, "c3")
m.addConstr(4*strawberries + 9*ravioli + 16*chicken >= 27, "c4")
m.addConstr(7*pizza + 4*strawberries + 16*chicken >= 27, "c5")
m.addConstr(7*pizza**2 + 4*strawberries**2 + 9*ravioli**2 >= 39, "c6")
m.addConstr(4*strawberries + 9*ravioli + 16*chicken >= 39, "c7")
m.addConstr(7*pizza + 4*strawberries + 16*chicken >= 39, "c8")
m.addConstr(7*pizza + 4*strawberries + 9*ravioli >= 39, "c9")
m.addConstr(4*strawberries + 9*ravioli + 16*chicken >= 39, "c10")
m.addConstr(7*pizza + 4*strawberries + 16*chicken >= 39, "c11")
m.addConstr(pizza + 20*ravioli >= 19, "c12")
m.addConstr(3*strawberries + 20*ravioli >= 14, "c13")
m.addConstr(pizza + 3*strawberries >= 10, "c14")
m.addConstr(pizza + 8*chicken >= 9, "c15")
m.addConstr(3*strawberries + 20*ravioli + 8*chicken >= 15, "c16")
m.addConstr(pizza**2 + 3*strawberries**2 + 20*ravioli**2 >= 15, "c17")
m.addConstr(3*strawberries**2 + 20*ravioli**2 + 8*chicken**2 >= 16, "c18")
m.addConstr(pizza + 3*strawberries + 20*ravioli >= 16, "c19")
m.addConstr(15*strawberries + 17*ravioli + 16*chicken >= 33, "c20")
m.addConstr(3*pizza**2 + 15*strawberries**2 + 17*ravioli**2 >= 33, "c21")
m.addConstr(15*strawberries + 17*ravioli + 16*chicken >= 33, "c22")
m.addConstr(3*pizza + 15*strawberries + 17*ravioli >= 33, "c23")
m.addConstr(7*pizza**2 + 9*ravioli**2 <= 105, "c24")
m.addConstr(9*ravioli + 16*chicken <= 146, "c25")
m.addConstr(4*strawberries**2 + 16*chicken**2 <= 68, "c26")
m.addConstr(4*strawberries + 9*ravioli + 16*chicken <= 119, "c27")
m.addConstr(7*pizza + 9*ravioli + 16*chicken <= 96, "c28")
m.addConstr(7*pizza + 4*strawberries + 9*ravioli + 16*chicken <= 96, "c29")
m.addConstr(pizza + 3*strawberries <= 48, "c30")
m.addConstr(20*ravioli + 8*chicken <= 77, "c31")
m.addConstr(pizza**2 + 20*ravioli**2 <= 57, "c32")
m.addConstr(pizza + 8*chicken <= 79, "c33")
m.addConstr(3*strawberries**2 + 20*ravioli**2 <= 28, "c34")
m.addConstr(pizza + 3*strawberries + 20*ravioli + 8*chicken <= 28, "c35")
m.addConstr(3*pizza + 15*strawberries <= 107, "c36")
m.addConstr(3*pizza**2 + 17*ravioli**2 <= 100, "c37")
m.addConstr(17*ravioli**2 + 16*chicken**2 <= 39, "c38")
m.addConstr(15*strawberries + 17*ravioli <= 55, "c39")
m.addConstr(15*strawberries + 16*chicken <= 47, "c40")
m.addConstr(3*pizza + 15*strawberries + 17*ravioli + 16*chicken <= 47, "c41")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

