
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B5")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B7")


    # Set objective function
    m.setObjective(2.4 * x0 + 9.41 * x1 + 7.62 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(28 * x0 + 12 * x2 >= 21, "kidney_zinc_b7")
    m.addConstr(28 * x1 + 12 * x2 >= 22, "kidney_b5_b7")
    m.addConstr(28 * x0 + 28 * x1 + 12 * x2 >= 22, "kidney_all")
    m.addConstr(29 * x1 + 11 * x2 >= 33, "digestive_b5_b7")
    m.addConstr(21 * x0 + 29 * x1 >= 75, "digestive_zinc_b5")
    m.addConstr(21 * x0 + 11 * x2 >= 35, "digestive_zinc_b7")
    m.addConstr(21 * x0 + 29 * x1 + 11 * x2 >= 61, "digestive_all")
    m.addConstr(-3 * x0 + 7 * x1 >= 0, "zinc_b5_ratio")
    m.addConstr(-10 * x0 + 6 * x2 >= 0, "zinc_b7_ratio")
    m.addConstr(28 * x1 + 12 * x2 <= 156, "kidney_b5_b7_upper")
    m.addConstr(28 * x0 + 28 * x1 + 12 * x2 <= 138, "kidney_all_upper")
    m.addConstr(21 * x0 + 11 * x2 <= 276, "digestive_zinc_b7_upper")
    m.addConstr(21 * x0 + 29 * x1 <= 203, "digestive_zinc_b5_upper")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
