
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_zinc", lb=0)
    x1 = model.addVar(name="milligrams_of_vitamin_B5", lb=0)
    x2 = model.addVar(name="milligrams_of_vitamin_B7", lb=0)

    # Define the objective function
    model.setObjective(2.4 * x0 + 9.41 * x1 + 7.62 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(28 * x0 <= 179)
    model.addConstr(21 * x0 <= 284)
    model.addConstr(28 * x1 <= 179)
    model.addConstr(29 * x1 <= 284)
    model.addConstr(12 * x2 <= 179)
    model.addConstr(11 * x2 <= 284)
    model.addConstr(28 * x0 + 12 * x2 >= 21)
    model.addConstr(28 * x1 + 12 * x2 >= 22)
    model.addConstr(28 * x0 + 28 * x1 + 12 * x2 >= 22)
    model.addConstr(29 * x1 + 11 * x2 >= 33)
    model.addConstr(21 * x0 + 29 * x1 >= 75)
    model.addConstr(21 * x0 + 11 * x2 >= 35)
    model.addConstr(21 * x0 + 29 * x1 + 11 * x2 >= 61)
    model.addConstr(21 * x0 + 29 * x1 + 11 * x2 >= 61)
    model.addConstr(-3 * x0 + 7 * x1 >= 0)
    model.addConstr(-10 * x0 + 6 * x2 >= 0)
    model.addConstr(28 * x1 + 12 * x2 <= 156)
    model.addConstr(28 * x0 + 28 * x1 + 12 * x2 <= 138)
    model.addConstr(21 * x0 + 11 * x2 <= 276)
    model.addConstr(21 * x0 + 29 * x1 <= 203)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of zinc: {x0.varValue}")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of vitamin B7: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
